/* Set values for gallery auto-rotation */
var iCurrent = 1; 	// Sets the first gallery image
var timer;  		// Variable for timer
var iSeconds = 10; 	// Number of seconds between rotations
var iMax; 			// Creates variable for the number of gallery images

/* Set inital promo and nav icon on page load */
var currentSlide = "div#slide"+iCurrent;
var currentNav   = "a#slideNav"+iCurrent;

$(document).ready(function(){
	iMax = $("#slideshow-wrapper > .slide").size();
	
	/*Dynamically Add Nav Buttons*/
	if (iMax > 1) {
		var slideNav = '<div id="slideNav">' +	'<ul>';
		for (i=1; i<=iMax; i++) {
			slideNav += '<li><a id="slideNav' + i + '" class="slideNav" href="#slide' + i + '">' + i + '</a></li>';
		}
		slideNav += '</ul>' + '</div>';
		
		$("#slide" + iMax).after(slideNav);
	}		

	/* Set initial gallery nav state */
	$(currentNav).addClass("selected");
	
	/* Start timer */
	timer = setInterval("ChangeSlide($(currentNav), $('a#slideNav'+getNextID()))", (iSeconds*1000));
	
	/* add click event function to switch promos */
	$("div#slideNav a.slideNav").click(function () {
		ChangeSlide($(currentNav), $(this));
		return false;
	});
	
});
		
/* Function to switch promos and restart timer */
function ChangeSlide(oCurrent, oNew) {
	// If the user clicks on a different item than the current item
	if ($(oCurrent).attr('href') != $(oNew).attr('href')) {
		// Update classes on  nav items
		$(oCurrent).removeClass("selected");
		$(oNew).addClass("selected");
		
		// Update current nav item
		currentNav = $(oNew);
		
		var newSlideHref = $(oNew).attr('href');
		var newSlide = newSlideHref.substr(newSlideHref.indexOf("#"), 7)

		// Fade photos to switch
		$(currentSlide).fadeOut('fast', function() {
			if(jQuery.browser.msie)
  			 this.style.removeAttribute('filter');
		});
		$(newSlide).fadeIn('fast', function() {
			if(jQuery.browser.msie)
  			 this.style.removeAttribute('filter');
		});
		
		// Update current item
		currentSlide = newSlide;
		iCurrent = Number(currentSlide.substring(6));
		
		clearInterval(timer);
		timer = setInterval("ChangeSlide($(currentNav), $('a#slideNav'+getNextID()))", (iSeconds*1000));
	};
};

/* Gets ID of next promo for auto-rotate */
function getNextID() {
	iCurrent==iMax ? iCurrent=1 : iCurrent++;
	return iCurrent;
}

/* update on 01/11/2010 */

/* try to stop the slide on mouse over */
function stopSlide(slideImg)
{
	var slideId = slideImg.parentNode.parentNode.id;			
	iCurrent = Number(slideId.substring(5));	
	currentNav = 'a#slideNav'+iCurrent;
	clearInterval(timer);
	timer = setInterval("ChangeSlide($(currentNav), $(currentNav))", (3600*1000));
}

/* continue the slide show on mouse out */
function continueSlide()
{
	pausedSlide = 'a#slideNav'+iCurrent;			
	$(pausedSlide).removeClass("selected");		
	
	if (iCurrent == iMax){ iCurrent = 0;}
	iCurrent +=1;
	nextNav  = 'a#slideNav'+iCurrent;	
	$(nextNav).click();
	$(nextNav).addClass("selected");		
}
/* end continue slide */

// exit box begin

	// detect ext links
	var isIE5 = false;	
	if ( $.browser.msie ) {
		if ($.browser.version < 6){isIE5 = true;}
	}
	
		var urlarray = new Array();
		var linkUrl;	
		jQuery(document).ready(function() {
		$("a").each(function() {
			var $a = jQuery(this);   
			if (!isIE5){
				if (this.href != null && !$a.is(".exempt")) {
					if (isExternalLink(this.href)){	
						$a.click(function() {
							$("#exitBoxDiv").modal({
													opacity:80,
													overlayCss: {backgroundColor:"#000"},											
													onOpen: function (dialog) {
														dialog.overlay.fadeIn('fast', function () {
															dialog.data.hide();
															dialog.container.fadeIn('fast', function () {
																dialog.data.slideDown('fast');
															});
														});
													},											
													onClose: function (dialog) {
														dialog.data.fadeOut('fast', function () {
															dialog.container.hide('fast', function () {
																dialog.overlay.slideUp('fast', function () {
																	$.modal.close();
																});
															});
														});
													} // end onClose
											}); // end modal
							
							var urlarray = this.href.split('?url=');
							linkUrl = urlarray[1];
							var iframeObj = document.getElementById('xbox_iframe');					
							iframeObj.src = "ext_redirect.asp?url="+linkUrl+"&xbox=1";										
							return false;						
						});
					}		            
				}
			} // not IE5
		});		
}); // jQuery(document)

function isExternalLink(url)
{
	if (url.toLowerCase().indexOf('ext_redirect') != -1)
		return true;
	else
		return false;	
}

// end exit box

// JavaScript Document

